/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.material.ItemPetal;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.BlockstateProvider;
import vazkii.botania.data.util.ModelWithOverrides;
import vazkii.botania.data.util.OverrideHolder;
import vazkii.botania.data.util.SimpleModelSupplierWithOverrides;
import vazkii.botania.mixin.AccessorTextureSlot;

public class ItemModelProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final TextureSlot LAYER1 = AccessorTextureSlot.make("layer1");
    private static final TextureSlot LAYER2 = AccessorTextureSlot.make("layer2");
    private static final TextureSlot LAYER3 = AccessorTextureSlot.make("layer3");
    private static final ModelTemplate GENERATED_1 = new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1});
    private static final ModelTemplate GENERATED_2 = new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1, LAYER2});
    private static final ModelTemplate HANDHELD_1 = new ModelTemplate(Optional.of(new ResourceLocation("item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1});
    private static final ModelTemplate HANDHELD_3 = new ModelTemplate(Optional.of(new ResourceLocation("item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1, LAYER2, LAYER3});
    private static final TextureSlot OUTSIDE = AccessorTextureSlot.make("outside");
    private static final TextureSlot CORE = AccessorTextureSlot.make("core");
    private static final ModelTemplate SPREADER = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_item")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125874_, TextureSlot.f_176491_, OUTSIDE, CORE});
    private static final ModelWithOverrides GENERATED_OVERRIDES = new ModelWithOverrides(new ResourceLocation("item/generated"), TextureSlot.f_125863_);
    private static final ModelWithOverrides GENERATED_OVERRIDES_1 = new ModelWithOverrides(new ResourceLocation("item/generated"), TextureSlot.f_125863_, LAYER1);
    private static final ModelWithOverrides HANDHELD_OVERRIDES = new ModelWithOverrides(new ResourceLocation("item/handheld"), TextureSlot.f_125863_);
    private static final ModelWithOverrides HANDHELD_OVERRIDES_2 = new ModelWithOverrides(new ResourceLocation("item/handheld"), TextureSlot.f_125863_, LAYER1, LAYER2);
    private final DataGenerator generator;
    private static final String BUILTIN_ENTITY_DISPLAY_STR = "{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}";
    private static final JsonElement BUILTIN_ENTITY_DISPLAY = (JsonElement)GSON.fromJson("{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}", JsonElement.class);

    public ItemModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) {
        Set<Item> items = Registry.f_122827_.m_123024_().filter(i -> "botania".equals(Registry.f_122827_.m_7981_(i).m_135827_())).collect(Collectors.toSet());
        HashMap map = new HashMap();
        this.registerItemBlocks(BlockstateProvider.takeAll(items, i -> i instanceof BlockItem).stream().map(i -> (BlockItem)i).collect(Collectors.toSet()), map::put);
        ItemModelProvider.registerItemOverrides(items, map::put);
        ItemModelProvider.registerItems(items, map::put);
        for (Map.Entry e : map.entrySet()) {
            ResourceLocation id = (ResourceLocation)e.getKey();
            Path out = this.generator.m_123916_().resolve("assets/" + id.m_135827_() + "/models/" + id.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((JsonElement)((Supplier)e.getValue()).get()), (Path)out);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Failed to generate {}", (Object)out, (Object)ex);
            }
        }
    }

    private static void registerItems(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        items.remove(ModItems.manaGun);
        BlockstateProvider.takeAll(items, i -> i instanceof ItemLens).forEach(i -> {
            ResourceLocation lens = i == ModItems.lensTime || i == ModItems.lensWarp || i == ModItems.lensFire ? ResourceLocationHelper.prefix("item/lens_small") : ResourceLocationHelper.prefix("item/lens");
            GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)lens).m_125758_(LAYER1, TextureMapping.m_125778_((Item)i)), consumer);
        });
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)ModItems.bloodPendant), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)ModItems.bloodPendant)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.bloodPendant, (String)"_overlay")), consumer);
        items.remove(ModItems.bloodPendant);
        HANDHELD_1.m_125612_(ModelLocationUtils.m_125571_((Item)ModItems.enderDagger), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)ModItems.enderDagger)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.enderDagger, (String)"_overlay")), consumer);
        items.remove(ModItems.enderDagger);
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)ModItems.incenseStick), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)ModItems.incenseStick)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.incenseStick, (String)"_overlay")), consumer);
        items.remove(ModItems.incenseStick);
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)ModItems.manaMirror), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)ModItems.manaMirror)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.manaMirror, (String)"_overlay")), consumer);
        items.remove(ModItems.manaMirror);
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)ModItems.manaTablet), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)ModItems.manaTablet)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.manaTablet, (String)"_overlay")), consumer);
        items.remove(ModItems.manaTablet);
        GENERATED_2.m_125612_(ModelLocationUtils.m_125571_((Item)ModItems.thirdEye), new TextureMapping().m_125758_(TextureSlot.f_125863_, TextureMapping.m_125745_((Item)ModItems.thirdEye, (String)"_0")).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.thirdEye, (String)"_1")).m_125758_(LAYER2, TextureMapping.m_125745_((Item)ModItems.thirdEye, (String)"_2")), consumer);
        items.remove(ModItems.thirdEye);
        BlockstateProvider.takeAll(items, ModItems.cobbleRod, ModItems.dirtRod, ModItems.diviningRod, ModItems.elementiumAxe, ModItems.elementiumPick, ModItems.elementiumShovel, ModItems.elementiumHoe, ModItems.elementiumSword, ModItems.exchangeRod, ModItems.fireRod, ModItems.glassPick, ModItems.gravityRod, ModItems.manasteelAxe, ModItems.manasteelPick, ModItems.manasteelShears, ModItems.manasteelShovel, ModItems.manasteelHoe, ModItems.missileRod, ModItems.obedienceStick, ModItems.rainbowRod, ModItems.smeltRod, ModItems.starSword, ModItems.terraSword, ModItems.terraformRod, ModItems.thunderSword, ModItems.waterRod, ModItems.kingKey, ModItems.skyDirtRod).forEach(i -> ModelTemplates.f_125659_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), consumer));
        BlockstateProvider.takeAll(items, i -> true).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), consumer));
    }

    private static void singleGeneratedOverride(Item item, ResourceLocation overrideModel, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ModelTemplates.f_125658_.m_125612_(overrideModel, TextureMapping.m_125820_((ResourceLocation)overrideModel), consumer);
        GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125766_((Item)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleGeneratedSuffixOverride(Item item, String suffix, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleGeneratedOverride(item, ModelLocationUtils.m_125573_((Item)item, (String)suffix), predicate, value, consumer);
    }

    private static void singleHandheldOverride(Item item, ResourceLocation overrideModel, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ModelTemplates.f_125659_.m_125612_(overrideModel, TextureMapping.m_125820_((ResourceLocation)overrideModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125766_((Item)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleHandheldSuffixOverride(Item item, String suffix, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleHandheldOverride(item, ModelLocationUtils.m_125573_((Item)item, (String)suffix), predicate, value, consumer);
    }

    private static void registerItemOverrides(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        items.remove(ModItems.livingwoodBow);
        items.remove(ModItems.crystalBow);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.blackHoleTalisman, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.blackHoleTalisman);
        OverrideHolder flaskOverrides = new OverrideHolder();
        for (int i = 1; i <= 5; ++i) {
            ResourceLocation overrideModel = ModelLocationUtils.m_125573_((Item)ModItems.brewFlask, (String)("_" + i));
            GENERATED_1.m_125612_(overrideModel, TextureMapping.m_125766_((Item)ModItems.flask).m_125758_(LAYER1, overrideModel), consumer);
            flaskOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)ModItems.brewFlask), TextureMapping.m_125766_((Item)ModItems.flask).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.brewFlask, (String)"_0")), flaskOverrides, consumer);
        items.remove(ModItems.brewFlask);
        OverrideHolder vialOverrides = new OverrideHolder();
        for (int i = 1; i <= 3; ++i) {
            Item[] overrideModel = ModelLocationUtils.m_125573_((Item)ModItems.brewVial, (String)("_" + i));
            GENERATED_1.m_125612_((ResourceLocation)overrideModel, TextureMapping.m_125766_((Item)ModItems.vial).m_125758_(LAYER1, (ResourceLocation)overrideModel), consumer);
            vialOverrides.add((ResourceLocation)overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)ModItems.brewVial), TextureMapping.m_125766_((Item)ModItems.vial).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.brewVial, (String)"_0")), vialOverrides, consumer);
        items.remove(ModItems.brewVial);
        ItemModelProvider.singleHandheldOverride(ModItems.elementiumShears, ResourceLocationHelper.prefix("item/dammitreddit"), ResourceLocationHelper.prefix("reddit"), 1.0, consumer);
        items.remove(ModItems.elementiumShears);
        ResourceLocation vuvuzela = ResourceLocationHelper.prefix("item/vuvuzela");
        ModelTemplates.f_125659_.m_125612_(vuvuzela, TextureMapping.m_125820_((ResourceLocation)vuvuzela), consumer);
        for (Item i : new Item[]{ModItems.grassHorn, ModItems.leavesHorn, ModItems.snowHorn}) {
            GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), new OverrideHolder().add(vuvuzela, Pair.of((Object)ResourceLocationHelper.prefix("vuvuzela"), (Object)1.0)), consumer);
        }
        items.remove(ModItems.grassHorn);
        items.remove(ModItems.leavesHorn);
        items.remove(ModItems.snowHorn);
        ItemModelProvider.singleGeneratedOverride(ModItems.infiniteFruit, ResourceLocationHelper.prefix("item/dasboot"), ResourceLocationHelper.prefix("boot"), 1.0, consumer);
        items.remove(ModItems.infiniteFruit);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.lexicon, "_elven", ResourceLocationHelper.prefix("elven"), 1.0, consumer);
        items.remove((Object)ModItems.lexicon);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.magnetRing, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.magnetRing);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.magnetRingGreater, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.magnetRingGreater);
        OverrideHolder bottleOverrides = new OverrideHolder();
        for (int i = 1; i <= 5; ++i) {
            ResourceLocation overrideModel = ModelLocationUtils.m_125573_((Item)ModItems.manaBottle, (String)("_" + i));
            ModelTemplates.f_125658_.m_125612_(overrideModel, TextureMapping.m_125820_((ResourceLocation)overrideModel), consumer);
            bottleOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ModItems.manaBottle), TextureMapping.m_125766_((Item)ModItems.manaBottle), bottleOverrides, consumer);
        items.remove(ModItems.manaBottle);
        ItemModelProvider.singleGeneratedOverride(ModItems.manaCookie, ResourceLocationHelper.prefix("item/totalbiscuit"), ResourceLocationHelper.prefix("totalbiscuit"), 1.0, consumer);
        items.remove(ModItems.manaCookie);
        ItemModelProvider.singleHandheldOverride(ModItems.manasteelSword, ResourceLocationHelper.prefix("item/elucidator"), ResourceLocationHelper.prefix("elucidator"), 1.0, consumer);
        items.remove(ModItems.manasteelSword);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveHelm, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveHelm);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveChest, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveChest);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveLegs, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveLegs);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveBoots, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveBoots);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.slimeBottle, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.slimeBottle);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.spawnerMover, "_full", ResourceLocationHelper.prefix("full"), 1.0, consumer);
        items.remove(ModItems.spawnerMover);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.temperanceStone, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.temperanceStone);
        ItemModelProvider.singleHandheldSuffixOverride(ModItems.terraAxe, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.terraAxe);
        ResourceLocation enabledModel = ModelLocationUtils.m_125573_((Item)ModItems.terraPick, (String)"_active");
        HANDHELD_1.m_125612_(enabledModel, TextureMapping.m_125766_((Item)ModItems.terraPick).m_125758_(LAYER1, enabledModel), consumer);
        ResourceLocation tippedModel = ModelLocationUtils.m_125573_((Item)ModItems.terraPick, (String)"_tipped");
        ModelTemplates.f_125659_.m_125612_(tippedModel, TextureMapping.m_125820_((ResourceLocation)tippedModel), consumer);
        ResourceLocation tippedEnabledModel = ModelLocationUtils.m_125573_((Item)ModItems.terraPick, (String)"_tipped_active");
        HANDHELD_1.m_125612_(tippedEnabledModel, TextureMapping.m_125820_((ResourceLocation)tippedModel).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.terraPick, (String)"_active")), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ModItems.terraPick), TextureMapping.m_125766_((Item)ModItems.terraPick), new OverrideHolder().add(enabledModel, Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)).add(tippedModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0)).add(tippedEnabledModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0), Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)), consumer);
        items.remove(ModItems.terraPick);
        ItemModelProvider.singleHandheldSuffixOverride(ModItems.tornadoRod, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.tornadoRod);
        TextureMapping twigWandTextures = TextureMapping.m_125766_((Item)ModItems.twigWand).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.twigWand, (String)"_top")).m_125758_(LAYER2, TextureMapping.m_125745_((Item)ModItems.twigWand, (String)"_bottom"));
        ResourceLocation twigWandBind = ModelLocationUtils.m_125573_((Item)ModItems.twigWand, (String)"_bind");
        HANDHELD_3.m_125612_(twigWandBind, twigWandTextures.m_125785_(LAYER3, TextureMapping.m_125745_((Item)ModItems.twigWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(ModelLocationUtils.m_125571_((Item)ModItems.twigWand), twigWandTextures, new OverrideHolder().add(twigWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(ModItems.twigWand);
        TextureMapping dreamwoodWandTextures = TextureMapping.m_125766_((Item)ModItems.dreamwoodWand).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ModItems.dreamwoodWand, (String)"_top")).m_125758_(LAYER2, TextureMapping.m_125745_((Item)ModItems.dreamwoodWand, (String)"_bottom"));
        ResourceLocation dreamwoodWandBind = ModelLocationUtils.m_125573_((Item)ModItems.dreamwoodWand, (String)"_bind");
        HANDHELD_3.m_125612_(dreamwoodWandBind, dreamwoodWandTextures.m_125785_(LAYER3, TextureMapping.m_125745_((Item)ModItems.dreamwoodWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(ModelLocationUtils.m_125571_((Item)ModItems.dreamwoodWand), dreamwoodWandTextures, new OverrideHolder().add(dreamwoodWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(ModItems.dreamwoodWand);
    }

    private void registerItemBlocks(Set<BlockItem> itemBlocks, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        itemBlocks.remove(ModBlocks.corporeaCrystalCube.m_5456_());
        itemBlocks.removeIf(i -> {
            ResourceLocation id = Registry.f_122824_.m_7981_((Object)i.m_40614_());
            return id.m_135827_().equals("botania") && i.m_40614_() instanceof BlockFloatingFlower;
        });
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)ModBlocks.animatedTorch.m_5456_()), TextureMapping.m_125738_((Block)Blocks.f_50174_).m_125758_(LAYER1, ResourceLocationHelper.prefix("block/animated_torch_glimmer")), consumer);
        itemBlocks.remove(ModBlocks.animatedTorch.m_5456_());
        ModelTemplates.f_125664_.m_125612_(ModelLocationUtils.m_125571_((Item)ModBlocks.gaiaHead.m_5456_()), new TextureMapping(), consumer);
        itemBlocks.remove(ModBlocks.gaiaHead.m_5456_());
        BlockstateProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof BlockModDoubleFlower).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_top")), consumer));
        BlockstateProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof BlockPetalBlock).forEach(i -> consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/petal_block"))));
        BlockstateProvider.takeAll(itemBlocks, ModBlocks.livingwoodFramed.m_5456_(), ModBlocks.dreamwoodFramed.m_5456_()).forEach(i -> {
            String name = i == ModBlocks.livingwoodFramed.m_5456_() ? "livingwood" : "dreamwood";
            consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_" + name + "_horizontal_z")));
        });
        consumer.accept(ModelLocationUtils.m_125571_((Item)ModBlocks.livingwoodFramed.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_livingwood_horizontal_z")));
        consumer.accept(ModelLocationUtils.m_125571_((Item)ModBlocks.dreamwoodFramed.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_dreamwood_horizontal_z")));
        itemBlocks.remove(ModBlocks.livingwoodFramed.m_5456_());
        itemBlocks.remove(ModBlocks.dreamwoodFramed.m_5456_());
        BlockstateProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof IronBarsBlock).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            String baseName = name.substring(0, name.length() - "_pane".length());
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        Predicate<BlockItem> defaultGenerated = i -> {
            Block b = i.m_40614_();
            return b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockLightRelay || b instanceof BlockModFlower || b == ModBlocks.ghostRail;
        };
        BlockstateProvider.takeAll(itemBlocks, defaultGenerated).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125738_((Block)i.m_40614_()), consumer));
        BlockstateProvider.takeAll(itemBlocks, b -> b.m_40614_() instanceof BlockMotifFlower).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            ResourceLocation texName = ResourceLocationHelper.prefix("block/" + name.replace("_motif", ""));
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)texName), consumer);
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof BlockPool).forEach(i -> {
            ResourceLocation fullModel = ModelLocationUtils.m_125578_((Block)i.m_40614_(), (String)"_full");
            OverrideHolder overrides = new OverrideHolder().add(fullModel, Pair.of((Object)ResourceLocationHelper.prefix("full"), (Object)1.0));
            consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)((Object)new SimpleModelSupplierWithOverrides(ModelLocationUtils.m_125576_((Block)i.m_40614_()), overrides)));
        });
        BlockstateProvider.takeAll(itemBlocks, (BlockItem[])Stream.of(ModFluffBlocks.livingwoodWall, ModFluffBlocks.livingwoodStrippedWall, ModFluffBlocks.dreamwoodWall, ModFluffBlocks.dreamwoodStrippedWall).map(b -> (BlockItem)b.m_5456_()).toArray(BlockItem[]::new)).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            String baseName = name.substring(0, name.length() - "_wall".length()) + "_log";
            ModelTemplates.f_125714_.m_125612_(ModelLocationUtils.m_125571_((Item)i), new TextureMapping().m_125758_(TextureSlot.f_125884_, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof WallBlock).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            String baseName = name.substring(0, name.length() - "_wall".length());
            ModelTemplates.f_125714_.m_125612_(ModelLocationUtils.m_125571_((Item)i), new TextureMapping().m_125758_(TextureSlot.f_125884_, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof BlockSpreader).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            Object outside = i.m_40614_() == ModBlocks.elvenSpreader ? "dreamwood_log_3" : (i.m_40614_() == ModBlocks.gaiaSpreader ? name + "_outside" : "livingwood_log");
            Object inside = i.m_40614_() == ModBlocks.elvenSpreader ? "stripped_dreamwood_log_3" : (i.m_40614_() == ModBlocks.gaiaSpreader ? name + "_inside" : "stripped_livingwood_log");
            SPREADER.m_125612_(ModelLocationUtils.m_125571_((Item)i), new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_side")).m_125758_(OUTSIDE, ResourceLocationHelper.prefix("block/" + (String)outside)).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_back")).m_125758_(TextureSlot.f_176491_, ResourceLocationHelper.prefix("block/" + (String)inside)).m_125758_(CORE, TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_core")), consumer);
        });
        BlockstateProvider.takeAll(itemBlocks, ModBlocks.avatar.m_5456_(), ModBlocks.bellows.m_5456_(), ModBlocks.brewery.m_5456_(), ModBlocks.corporeaIndex.m_5456_(), ModBlocks.gaiaPylon.m_5456_(), ModBlocks.hourglass.m_5456_(), ModBlocks.manaPylon.m_5456_(), ModBlocks.naturaPylon.m_5456_(), ModBlocks.teruTeruBozu.m_5456_()).forEach(i -> this.builtinEntity((Item)i, consumer));
        BlockstateProvider.takeAll(itemBlocks, i -> i instanceof ItemPetal).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)ResourceLocationHelper.prefix("item/petal")), consumer));
        ModelTemplates.f_125710_.m_125612_(ModelLocationUtils.m_125571_((Item)ModFluffBlocks.dreamwoodFence.m_5456_()), TextureMapping.m_125768_((Block)ModBlocks.dreamwoodPlanks), consumer);
        itemBlocks.remove(ModFluffBlocks.dreamwoodFence.m_5456_());
        ModelTemplates.f_125710_.m_125612_(ModelLocationUtils.m_125571_((Item)ModFluffBlocks.livingwoodFence.m_5456_()), TextureMapping.m_125768_((Block)ModBlocks.livingwoodPlanks), consumer);
        itemBlocks.remove(ModFluffBlocks.livingwoodFence.m_5456_());
        consumer.accept(ModelLocationUtils.m_125571_((Item)ModBlocks.elfGlass.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/elf_glass_0")));
        itemBlocks.remove(ModBlocks.elfGlass.m_5456_());
        itemBlocks.forEach(i -> consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.m_125576_((Block)i.m_40614_()))));
    }

    protected void builtinEntity(Item i, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        consumer.accept(ModelLocationUtils.m_125571_((Item)i), () -> {
            JsonObject json = new JsonObject();
            json.addProperty("parent", "minecraft:builtin/entity");
            json.add("display", BUILTIN_ENTITY_DISPLAY);
            return json;
        });
    }

    @Nonnull
    public String m_6055_() {
        return "Botania item models";
    }
}

